<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>">
    <head>
        
        <?php echo $__env->make('common.meta-tags', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        
        <?php echo $__env->make('common.default-icons', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        
        <?php echo $__env->make('common.default-styles', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        
        <?php echo $__env->yieldPushContent('stylesheet'); ?>

        <?php echo $__env->make('common.cookie-enabled', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        
        <style>
            #page-footer {
                padding-top:2rem;
                min-height: auto !important;
            }
        </style>

        
        <script>document.documentElement.className = 'js';</script>

        
        <?php echo $__env->make('common.schema.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php echo $__env->yieldPushContent('schema'); ?>


        <?php if( dcmConfig('app_custom_css') &&  dcmConfig('app_custom_css') != ''): ?>
            <style>
                <?php echo dcmConfig('app_custom_css'); ?>

            </style>
        <?php endif; ?>

        <?php if( dcmConfig('site_analytics') &&  dcmConfig('site_analytics') != ''): ?>
            <style>
                <?php echo dcmConfig('site_analytics'); ?>

            </style>
        <?php endif; ?>

        <?php if( dcmConfig('site_verification') &&  dcmConfig('site_verification') != ''): ?>
            <style>
                <?php echo dcmConfig('site_verification'); ?>

            </style>
        <?php endif; ?>

    </head>
    <body>

        <div id="page-container" class="page-header-dark main-content-boxed">

            <?php echo $__env->make('common.header', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <main id="main-container">
                <?php echo $__env->make('common.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <div class="content content-full">

                    <div class="row">


                        <?php if( $has_sidebar ?? true ): ?>
                            <div class="col-lg-8 col-xl-8">
                                <?php echo $__env->yieldContent('content'); ?>
                            </div>

                            <div class="col-lg-4 col-xl-4">
                                <?php echo $__env->make('web.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            </div>
                        <?php else: ?>
                            <div class="col-lg-12 col-xl-12">
                                <?php echo $__env->yieldContent('content'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
            <?php echo $__env->make('common.footer', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>

        
        <?php echo $__env->make('common.search-modal', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        
        <?php echo $__env->make('common.default-javascript', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>


        <?php echo $__env->make('common.search-modal-javascript', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>


        
        <?php echo $__env->yieldPushContent('javascript'); ?>


        <?php if( dcmConfig('app_custom_js') &&  dcmConfig('app_custom_js') != ''): ?>
            <script type="text/javascript">
                <?php echo dcmConfig('app_custom_js'); ?>

            </script>
        <?php endif; ?>
        
        <?php if( dcmConfig('add_this') &&  dcmConfig('add_this') != ''): ?>
            <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=<?php echo e(dcmConfig('add_this')); ?>"></script>
        <?php endif; ?>
    </body>
</html>